// ClientThread.cpp : implementation file
//

#include "stdafx.h"
#include "MyProxy.h"
#include "ClientThread.h"
#include <afxinet.h>

#include "Filtre.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClientThread

IMPLEMENT_DYNCREATE(CClientThread, CWinThread)

CClientThread::CClientThread(CMyProxyDlg *mother, SOCKET* sbrowser)
{
	m_pProxyDlg = mother;
	m_pSock     = sbrowser;
	memset(m_BrowserBuf, 0, BLKSIZE);
}

CClientThread::CClientThread()
{
}

CClientThread::~CClientThread()
{
}

BOOL CClientThread::InitInstance()
{
	// TODO:  perform and per-thread initialization here
	return TRUE;
}

int CClientThread::ExitInstance()
{
	// TODO:  perform any per-thread cleanup here
	return CWinThread::ExitInstance();
}

BEGIN_MESSAGE_MAP(CClientThread, CWinThread)
	//{{AFX_MSG_MAP(CClientThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClientThread message handlers

int CClientThread::Run() 
{
	CString str;					//error string
	SOCKET httpserv = 0;			//server socket
	struct sockaddr_in httpaddr;	//server socket structure
	int nr = 0;						//number of read bytes
	DWORD serviceType = 0;
	CString host;
	CString file;
	INTERNET_PORT port = 0;
	char *protocol = 0;		//HTTP protocol version
	char *command = 0;
	char *pc = 0;
	char *ext = 0;
	char *line = 0;
	bool isHtml = false;
	bool firstpass = true;
	char *content = 0;
	char *request;
	POSITION pos = 0;

	char *tag = 0,
		 *param = 0,
		 *value = 0;

	int nsize = 0;
	int diffsize = 0;
	char *buftemp;
	//DECLARATIONS
	bool premier = true;
	int  indexbuf = 0;
	char buf2[BLKSIZE];
	int  sizebuf2 = 0;


	//Receiving Request from Browser
	if( (nr = recv(*m_pSock, m_BrowserBuf, BLKSIZE, NULL)) == SOCKET_ERROR)
	{
		str.LoadString(IDS_BADCOMMAND);
		send(*m_pSock, str, str.GetLength(), NULL);
		goto fin;
	}

	//retrieve the first line
	pc = strchr(m_BrowserBuf, '\n');
	*(pc++) = '\0';
	command = strtok(m_BrowserBuf, " ");
	line = strtok(NULL, "\n");

	if(strcmp(command, "GET"))
	{
		if(strcmp(command, "POST"))
		{
			str.LoadString(IDS_BADCOMMAND);
			send(*m_pSock, str, str.GetLength(), NULL);
			goto fin;
		}
	}

	protocol = strrchr(line, ' ');
	*(protocol++) = '\0';

	if(!AfxParseURL( line, serviceType, host, file, port ))
	{
		str.LoadString(IDS_INVALIDADDRESS);
		send(*m_pSock, str, str.GetLength(), NULL);
		goto fin;
	}

	//retrieve file extension
	ext =  strchr(file, '.');
	if(ext)
	{
		if(!_strnicmp(ext, ".htm", 4))
			isHtml = true;
	}
	else
		//if no file extension is found, parse by default
		isHtml = true;



	if(serviceType != AFX_INET_SERVICE_HTTP)
	{
		str.LoadString(IDS_BADPROTOCOL);
		send(*m_pSock, str, str.GetLength(), NULL);
		goto fin;
	}

	if(_strnicmp(protocol, "HTTP/1.0", 8))
	{
		str.LoadString(IDS_BADPROTOCOL);
		send(*m_pSock, str, str.GetLength(), NULL);
		goto fin;
	}

	//Testing Request with Bannished Hosts List
	if(CheckBanHost(host.GetBuffer(host.GetLength())) == 0)
	{
		str.LoadString(IDS_BANHOST);
		send(*m_pSock, str, str.GetLength(), NULL);
		goto fin;
	}


	httpaddr.sin_family = AF_INET;
	
	 if(m_pProxyDlg->m_HasProxy)
	{
		httpaddr.sin_port = htons(m_pProxyDlg->m_ProxyPort);
		if(m_pProxyDlg->m_ProxyIp == 0)
		{
			if(GetHostEnt(httpaddr, 0) == SOCKET_ERROR)
			{
				str.LoadString(IDS_INVALIDADDRESS);
				send(*m_pSock, str, str.GetLength(), NULL);
				goto fin;
			}
		}
		else
			memcpy(&(httpaddr.sin_addr), &(m_pProxyDlg->m_ProxyIp), sizeof(DWORD));
	}
	else
	{
		if(GetHostEnt(httpaddr, host.GetBuffer(host.GetLength())) == SOCKET_ERROR)
		{
			str.LoadString(IDS_INVALIDADDRESS);
			send(*m_pSock, str, str.GetLength(), NULL);
			goto fin;
		}
		httpaddr.sin_port = htons(port);
	}

	//Connect to HTTP Server
	if(MakeConnect(&httpserv, httpaddr) == SOCKET_ERROR)
	{
		if(m_pProxyDlg->m_HasProxy)
			str.LoadString(IDS_BADPROXYADDRESS);
		else
			str.LoadString(IDS_URLNOTFOUND);
		send(*m_pSock, str, str.GetLength(), NULL);
		goto fin;
	}

	PostMessage(m_pProxyDlg->m_hWnd, WM_REF, 1, 0);

	//Send Request to HTTP Server
	if(m_pProxyDlg->m_HasProxy)
	{
		m_BrowserBuf[strlen(m_BrowserBuf)] = ' ';
		*(--protocol) = ' ';
		*(--pc) = '\n';
	}
	else
	{
		sprintf(m_BrowserBuf, "%s %s %s\012%s", command, file, protocol, pc);
		nr = nr - 7 - host.GetLength();
	}


	if(send(httpserv, m_BrowserBuf, nr, NULL) == SOCKET_ERROR)
	{
		AfxMessageBox("SEND HTTP SERVER ERROR");
		goto fin;
	}

	request = new char[7 + host.GetLength()+file.GetLength()+1];
	sprintf(request, "http://%s%s", host, file);
	PostMessage(m_pProxyDlg->m_hWnd, WM_REQ, 0, LPARAM(request));

	//Receiving from HTTP Server
	while((nr = recv(httpserv, m_BrowserBuf, BLKSIZE, NULL)) != 0)
	{
		if(nr == SOCKET_ERROR)
			goto fin;
		
		//retrieve the content-type
		if(!isHtml && firstpass)
		{
			content = strstr(m_BrowserBuf, "text/html");
		
			if(content != NULL)
				isHtml = true;
		}



		/*PARSE THE HTML FILE RIGHT HERE!!!!!!!!!!*/
		if(isHtml)
		{
			content = 0;
			premier = true;
			
			if(firstpass)
			{
				if( (content = strchr(m_BrowserBuf, '<')) != 0)
				{
					diffsize = content - m_BrowserBuf;
					if(send(*m_pSock, m_BrowserBuf, diffsize, NULL) == SOCKET_ERROR)
						goto fin;

					nr -= diffsize;

					buftemp = new char[nr];
					memcpy(buftemp, content, nr);
					memcpy(m_BrowserBuf, buftemp, nr);
					delete[] buftemp;
					firstpass = false;
				}
				else
				{
					if(send(*m_pSock, m_BrowserBuf, nr, NULL) == SOCKET_ERROR)
						goto fin;
					nr = 0;
				}
			}
			
			if(m_pProxyDlg->m_textOnly)
				Filtrer(m_BrowserBuf, indexbuf, nr, buf2, sizebuf2, premier,"IMG","SRC");

			//HTML Tags Reference List
			for( pos = m_pProxyDlg->m_banRef.GetHeadPosition(); pos != NULL; )
			{
				str = m_pProxyDlg->m_banRef.GetNext(pos);
				tag = new char[str.GetLength()+1];
				strcpy(tag, str.GetBuffer(str.GetLength()));
				strtok(tag, " ");
				param = strtok(NULL, " ");
				value = strtok(NULL, " ");

				Filtrer(m_BrowserBuf, indexbuf, nr, buf2, sizebuf2, premier,tag, param, value);

				delete[] tag;
				tag = param = value = 0;
			}

			
			if(sizebuf2>0)
			{
				if(send(*m_pSock, buf2, sizebuf2, NULL) == SOCKET_ERROR)
					goto fin;
			}

			if(nr>0)
			{
				if(send(*m_pSock, m_BrowserBuf+indexbuf, nr, NULL) == SOCKET_ERROR)
					goto fin;
			}
		}
		else
		{
			//Send Response to Browser
			if(send(*m_pSock, m_BrowserBuf, nr, NULL) == SOCKET_ERROR)
				goto fin;
			firstpass = false;
		}
	}

fin:
	closesocket(httpserv);
	PostMessage(m_pProxyDlg->m_hWnd, WM_REF, 0, 0);
	closesocket(*m_pSock);
	delete m_pSock;
	return 0;
}

//////////////////////////////////////////////////
//Client Implementation
UINT CClientThread::GetHostEnt(struct sockaddr_in &sad, char *addr)
{
	char in_host[100];
	struct hostent* myhostent=0;

	if(!addr)
	{
		if(gethostname(in_host, 100) == SOCKET_ERROR)
			return SOCKET_ERROR;
		
		if((myhostent=gethostbyname(in_host)) == 0)
			return SOCKET_ERROR;
	}
	else
	{
		if (isalpha(addr[0])) /* server address is a name */ 
			myhostent = gethostbyname(addr); 
		else  /* Convert nnn.nnn address to a usable one */ 
		{ 
			unsigned int iad;

			iad = inet_addr(addr); 
			myhostent = gethostbyaddr((char *)&iad,4,AF_INET); 
		}
		
		if (myhostent == NULL )
			return SOCKET_ERROR;
	}

	memcpy(&(sad.sin_addr), myhostent->h_addr, myhostent->h_length);
	return SOCKET_ERROR+1;
}

int CClientThread::MakeConnect(SOCKET *ps, struct sockaddr_in sad)
{
	if( (*ps = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == INVALID_SOCKET)
		return SOCKET_ERROR;

	if(connect(*ps, (struct sockaddr *) &sad, sizeof(sad)) == SOCKET_ERROR)
		return SOCKET_ERROR;

	return SOCKET_ERROR+1;
}

UINT CClientThread::CheckBanHost(char *ch)
{
	CString strban;					//banished host string
    POSITION pos = 0;				//position in string List

	for( pos = m_pProxyDlg->m_banHost.GetHeadPosition(); pos != NULL; )
	{
		strban = m_pProxyDlg->m_banHost.GetNext(pos);

		if(!_strnicmp(ch, strban, strban.GetLength()))
			return 0;
	}
	return 1;
}
